const { Telegraf } = require('telegraf');
const axios = require('axios');
const schedule = require('node-schedule');

const BOT_TOKEN = 'botkey';
const CHANNEL_ID = '@sswcnet';
const GROUP_ID = -1002047900492; // 替换你自己的群组 ID
const API_BASE_URL = 'https://shield.royalehosting.net/api/v2/attacks';
const API_KEY = 'apikey';
const TEST_DURATION = 600; //600s测试时间
const COOLDOWN_TIME = 300; //300s冷却时间
const UPDATE_INTERVAL = 30; //每30s更新一次攻击流量数据

const bot = new Telegraf(BOT_TOKEN);

let availableIPs = ['45.140.188.252','45.140.188.253','45.140.188.254','45.141.202.35','45.141.202.36','45.141.202.37','45.141.202.38','45.141.202.39','45.141.202.40','45.140.188.93', '45.140.188.95', '45.140.188.100', '45.140.188.101', '45.140.188.108','45.140.188.237'];
let cooldownIPs = new Set();
let totalUsers = new Set();
let cooldownUsers = new Set();

let totalTests = 0;
const fs = require('fs');

const STATS_FILE = 'stats.json';

function loadStats() {
    try {
        let data = fs.readFileSync(STATS_FILE, 'utf8');
        return JSON.parse(data);
    } catch (error) {
        console.log('📂 统计文件不存在，创建新的 stats.json');
        return { totalUsers: [], totalTests: 0 };
    }
}

function saveStats(stats) {
    fs.writeFileSync(STATS_FILE, JSON.stringify(stats, null, 2), 'utf8');
}

let stats = loadStats();

// 协议编号对应名称
const protocolMap = {
    1: 'ICMP',
    2: 'IGMP',
    6: 'TCP',
    7: 'Echo',
    17: 'UDP',
    41: 'IPv6 Encapsulation',
    47: 'GRE',
    50: 'ESP',
    51: 'AH',
    58: 'ICMPv6',
    89: 'OSPF',
    132: 'SCTP'
};

function convertToShanghaiTimestamp(utcTimeStr) {
    let utcTime = new Date(utcTimeStr.replace(' ', 'T') + 'Z');
    let shanghaiOffset = 0 * 60 * 60 * 1000;
    return (utcTime.getTime() + shanghaiOffset) / 1000;
}

async function getAttackData(targetIP, startTime) {
    try {
        const response = await axios.get(`${API_BASE_URL}?chunk=0&filter=${targetIP}`, {
            headers: { 'token': API_KEY }
        });

        const attacks = response.data.data.attacks || [];
        if (attacks.length === 0) return null;

        const validAttacks = attacks.filter(a => convertToShanghaiTimestamp(a.start_time) >= startTime-120);
        if (validAttacks.length === 0) return null;

        const maxAttack = validAttacks.reduce((prev, current) => (prev.mbps > current.mbps ? prev : current));
        return maxAttack.attack_id;
    } catch (error) {
        console.error('获取攻击历史数据失败:', error);
        return null;
    }
}

async function getAttackDetails(attackID) {
    try {
        const response = await axios.get(`${API_BASE_URL}/${attackID}`, {
            headers: { 'token': API_KEY }
        });

        const attack = response.data.data.attack;
        const info = response.data.data.info || {};

        const bandwidth = attack.mbps >= 1000 ? `${(attack.mbps / 1000).toFixed(2)} Gbps` : `${attack.mbps} Mbps`;
        const packetRate = attack.pps >= 1000000 ? `${(attack.pps / 1000000).toFixed(2)} MPPS` : `${attack.pps} PPS`;

        let protocolData = (info.prot || []).map(p => `${protocolMap[p.name] || `协议 ${p.name}`} (${((p.value / info.prot.reduce((sum, p) => sum + p.value, 0)) * 100).toFixed(2)}%)`).join('\n');

        let asnData = (info.sasn || []).map(a => `${a.name} (${((a.value / info.sasn.reduce((sum, a) => sum + a.value, 0)) * 100).toFixed(2)}%)`).join('\n');

        let countryData = (info.scountry || []).map(c => `${c.name} (${((c.value / info.scountry.reduce((sum, c) => sum + c.value, 0)) * 100).toFixed(2)}%)`).join('\n');

        let sourcePorts = (info.sport || []).map(p => `${p.name} (${((p.value / info.sport.reduce((sum, p) => sum + p.value, 0)) * 100).toFixed(2)}%)`).join('\n');

        let packetSizes = (info.plen || []).map(p => `${p.name} bytes (${((p.value / info.plen.reduce((sum, p) => sum + p.value, 0)) * 100).toFixed(2)}%)`).join('\n');

        return `
📊 **攻击详情**
📈 **最大流量**: ${bandwidth}
📦 **最大包速**: ${packetRate}
🔹 **攻击简介**: ${attack.description}
🔹 **协议类型**:
${protocolData}
🔹 **攻击包体大小**:
${packetSizes}
🔹 **攻击源端口**:
${sourcePorts}
🔹 **来源 ASN**:
${asnData}
🔹 **来源国家**:
${countryData}
        `;
    } catch (error) {
        console.error('获取攻击详细数据失败:', error);
        return '❌ 无法获取攻击详细数据。';
    }
}

bot.command('boot', async (ctx) => {
    let userId = ctx.from.id;

    let isMember = await bot.telegram.getChatMember(CHANNEL_ID, userId)
        .then(member => ['member', 'administrator', 'creator'].includes(member.status))
        .catch(() => false);

    if (!isMember) {
        return ctx.reply(`⚠️ 你必须先加入我们的频道和群组才能使用此功能！\n📢 频道: ${CHANNEL_ID}\n👥 群组: @sswcnet_group`);
    }
    if (cooldownUsers.has(userId)) {
        return ctx.reply(`⚠️ 您已经启动了一次测量，请稍后再试`);
    }
    let targetIP = availableIPs.find(ip => !cooldownIPs.has(ip));
    if (!targetIP) return ctx.reply('🚫 当前没有可用的测试 IP，请稍后再试！');

    cooldownIPs.add(targetIP);
    setTimeout(() => cooldownIPs.delete(targetIP), (TEST_DURATION + COOLDOWN_TIME) * 1000);

    if (!stats.totalUsers.includes(userId)) {
        stats.totalUsers.push(userId);
    }
    stats.totalTests++;
    saveStats(stats);
    cooldownUsers.add(userId);
    setTimeout(() => cooldownUsers.delete(userId), TEST_DURATION * 1000);
    ctx.reply(`✅ 测试已启动！请对 **${targetIP}** 进行攻击，测试时间 600s。\n📡 60 秒后开始数据监控。\n请在180秒内发送攻击，否则可能统计不上\n目前出数据较慢，请耐心等待(大概4-6分钟)`).then(sentMessage => {
        let messageId = sentMessage.message_id;
        let chatId = sentMessage.chat.id;

        let startTime = Math.floor(Date.now() / 1000);
        let sss;
        setTimeout(() => {
            const attackMonitor = setInterval(async () => {
                const attackID = await getAttackData(targetIP, startTime);
                if (!attackID) {
					let timestamp = new Date().toLocaleTimeString("zh-CN", { timeZone: "Asia/Shanghai" });
                    return bot.telegram.editMessageText(chatId, messageId, null, `🕒 更新时间: ${timestamp}\n\n⚠️ 当前 IP (${targetIP}) 暂无攻击流量数据。`);
                }

                const attackDetails = await getAttackDetails(attackID);
                let timestamp = new Date().toLocaleTimeString("zh-CN", { timeZone: "Asia/Shanghai" });
                sss = attackDetails;
                bot.telegram.editMessageText(chatId, messageId, null, `🕒 更新时间: ${timestamp}\n\n${attackDetails}`, { parse_mode: 'Markdown' });
            }, UPDATE_INTERVAL * 1000);

            setTimeout(() => {
                clearInterval(attackMonitor);
                const attackDetails = sss;
                bot.telegram.editMessageText(chatId, messageId, null, `{attackDetails}\n\n✅ 测试结束！IP **${targetIP}** `);
                bot.telegram.sendMessage("6078247461",  `${attackDetails}\n\n✅ 测试结束！IP **${targetIP}** \n\n测试者ID tg://openmessage?user_id=${chatId}`);
            }, TEST_DURATION * 1000);
        }, 1000);
    });
});
bot.command('start', async (ctx) => {
    let userId = ctx.from.id;

    let isMember = await bot.telegram.getChatMember(CHANNEL_ID, userId)
        .then(member => ['member', 'administrator', 'creator'].includes(member.status))
        .catch(() => false);

    if (!isMember) {
        return ctx.reply(`⚠️ 你必须先加入我们的频道和群组才能使用此功能！\n📢 频道: ${CHANNEL_ID}\n👥 群组: @sswcnet_group`);
    }
    if (!stats.totalUsers.includes(userId)) {
        stats.totalUsers.push(userId);
    }
    saveStats(stats); 
    return ctx.reply("#广告位1\n#广告位2\n请使用 /boot 启动测量");
});
bot.command('stats', async (ctx) => {
    let userId = ctx.from.id;

    let isAdmin = await bot.telegram.getChatMember(GROUP_ID, userId)
        .then(member => ['administrator', 'creator'].includes(member.status))
        .catch(() => false);

    if (!isAdmin) {
        return ctx.reply('❌ 你没有权限查看统计数据！');
    }

    let totalUsersCount = stats.totalUsers.length;
    let totalTestsCount = stats.totalTests;

    ctx.reply(`📊 **统计信息**\n👥 **累计用户数**: ${totalUsersCount}\n📡 **累计测量次数**: ${totalTestsCount}`);
});

bot.launch().then(() => console.log('🚀 Bot 启动成功！'));
